#include <iostream>
#include <vector>
#include <list>

using namespace std;

void add_edge(vector<int> adj[], int src, int dest)
{
    if (src != dest) {
        bool nadjen = false;
        for (int i = 0; i < adj[src].size() && !nadjen; i++)
        {
            if (adj[src][i] == dest) {
                nadjen = true;
            }
        }
        if (!nadjen) 
        {
            adj[src].push_back(dest);
            adj[dest].push_back(src);
        }
    }
}

bool BFS(vector<int> adj[], int src, int dest, int v, int pred[], int dist[])
{
    list<int> queue;
    bool* visited = new bool[v];

    for (int i = 0; i < v; i++) {
        visited[i] = false;
        dist[i] = INT_MAX;
        pred[i] = -1;
    }

    visited[src] = true;
    dist[src] = 0;
    queue.push_back(src);

    while (!queue.empty()) {
        int u = queue.front();
        queue.pop_front();
        for (int i = 0; i < adj[u].size(); i++) {
            if (visited[adj[u][i]] == false) {
                visited[adj[u][i]] = true;
                dist[adj[u][i]] = dist[u] + 1;
                pred[adj[u][i]] = u;
                queue.push_back(adj[u][i]);

                if (adj[u][i] == dest)
                    return true;
            }
        }
    }

    return false;
}

void printShortestDistance(vector<int> adj[], int s, int dest, int v)
{
    int* pred = new int[v];
    int* dist = new int[v];

    BFS(adj, s, dest, v, pred, dist);

    cout << dist[dest];
}

int main()
{
    int N, M, S, T;
    cin >> N >> M >> S >> T;
    
    vector<int>* adj = new vector<int>[N];

    int a, b;
    for (int i = 0; i < M; i++) 
    {
        cin >> a >> b;
        add_edge(adj, a - 1, b - 1);
    }


    vector<int>* adj2 = new vector<int>[N];
    for (int i = 0; i < N; i++)
    {
        for (int j = 0; j < adj[i].size(); j++)
        {
            add_edge(adj2, i, adj[i][j]);
            for (int k = j + 1; k < adj[i].size(); k++)
            {
                add_edge(adj2, adj[i][j], adj[i][k]);
            }
        }
    }

    printShortestDistance(adj2, S-1, T-1, N);

    return 0;
}