#include <iostream>
#include <vector>
#include <climits>
#include <set>

using namespace std;
const int INF = INT_MAX;

vector<int> dijkstra(const vector<vector<int>>& graph, int start) {
    int num_nodes = graph.size();
    vector<int> distances(num_nodes, INF);
    distances[start] = 0;

    set<pair<int, int>> unvisited;  // Koristimo set za cvorove koji se još uvek nisu posetili
    unvisited.insert({0, start});

    while (!unvisited.empty()) {
        int current_node = unvisited.begin()->second;
        unvisited.erase(unvisited.begin());

        for (int neighbor = 0; neighbor < num_nodes; ++neighbor) {
            if (graph[current_node][neighbor] == 1) {  // Provera susedstva
                int new_distance = distances[current_node] + 1;  // U ovom slucaju težine su sve 1
                if (new_distance < distances[neighbor]) {
                    unvisited.erase({distances[neighbor], neighbor});
                    distances[neighbor] = new_distance;
                    unvisited.insert({distances[neighbor], neighbor});
                }
            }
        }
    }

    return distances;
}

int main() {
   
    int n;
   
    int broj;
    
    int pocetak;
    
    int kraj;
    cin >> n >> broj >> pocetak >> kraj;
    int a, b;
    int mat[1000][1000];
        for (int i = 0; i < broj; i++) {
            cin >> a >> b;
            mat[a - 1][b - 1] = 1;
            mat[b - 1][a - 1] = 1;
        }

        int mat2[1000][1000];

        for (int i = 0; i < n; i++) {
            for (int j = 0; j < n; j++) {
                if (mat[i][j] == 1) {
                    for (int k = 0; k < n; k++) {
                        if (mat[j][k] == 1) {
                            mat2[i][k] = 1;
                        }
                    }
                }
            }
        }

     
     int num_nodes = sizeof(mat2) / sizeof(mat2[0]);
    vector<vector<int>> graph;
    for (int i = 0; i < num_nodes; ++i) {
        vector<int> row(mat2[i], mat2[i] + num_nodes);
        graph.push_back(row);
    }

    int start_node = pocetak-1;
    vector<int> distances = dijkstra(graph, start_node);

    int end_node = kraj-1;  // Cvor 5 (indeks 4 u vektoru)
    


    // Rekonstrukcija puta
    vector<int> path;
    int current_node = end_node;
    while (current_node != start_node) {
        path.push_back(current_node);
        for (int neighbor = 0; neighbor < num_nodes; ++neighbor) {
            if (graph[current_node][neighbor] == 1) {
                if (distances[current_node] == distances[neighbor] + 1) {
                    current_node = neighbor;
                    break;
                }
            }
        }
    }
    path.push_back(start_node);

   
    cout << path.size()-1<<endl;
    
   
}