from collections import defaultdict, deque


def bfs(start, end, graf):
    red = deque([(start, 0)])
    poseceno = set()
    poseceno.add(start)

    while red:
        trenutna, promene = red.popleft()

        if trenutna == end:
            return promene

        for sused in graf[trenutna]:
            if sused not in poseceno:
                poseceno.add(sused)
                red.append((sused, promene + 1))

    return -1


def main():
    N, M, S, T = map(int, input().split())
    stare_veze = [tuple(map(int, input().split())) for _ in range(M)]

    stari_graf = defaultdict(list)

    for u, v in stare_veze:
        stari_graf[u].append(v)
        stari_graf[v].append(u)

    novi_graf = defaultdict(list)

    for u in range(1, N + 1):
        for v in stari_graf[u]:
            for w in stari_graf[v]:
                if w != u:
                    novi_graf[u].append(w)

    rezultat = bfs(S, T, novi_graf)
    print(rezultat)


if __name__ == "__main__":
    main()