#include <iostream>

constexpr int N_MAX = 10000;
constexpr int M_MAX = N_MAX;

bool stari_plan[N_MAX][N_MAX];
bool  novi_plan[N_MAX][N_MAX];

int n, m, s, t;

bool pretrazene_stanice[N_MAX];

int pretraga(int trenutna_stanica, int broj_presedanja)
{
    // std::cout << "***" << trenutna_stanica + 1 << "***" << broj_presedanja << '\n';

    if (pretrazene_stanice[trenutna_stanica]) {
        return INT_MAX;
    }

    pretrazene_stanice[trenutna_stanica] = true;

    if (trenutna_stanica == t) {
        return broj_presedanja;
    }

    int min = INT_MAX;

    for (int i = 0; i < n; i++)
    {
        if (!novi_plan[trenutna_stanica][i]) {
            continue;
        }

        int bp = pretraga(i, broj_presedanja + 1);

        if (bp < min) {
            min = bp;
        }
    }

    return min;
}

int pretraga()
{
    for (int i = 0; i < n; i++) {
        pretrazene_stanice[i] = false;
    }

    return pretraga(s, 0);
}

int main(int argc, char const *argv[])
{
    std::cin >> n >> m >> s >> t;
    s--;
    t--;

    for (int i = 0; i < n; i++)
    {
        for (int j = 0; j < n; j++)
        {
            stari_plan[i][j] = false;
            novi_plan[i][j]  = false;
        }
    }

    for (int i = 0, a, b; i < m; i++)
    {
        std::cin >> a >> b;
        a--;
        b--;

        stari_plan[a][b] = true;
        stari_plan[b][a] = true;
    }

    for (int i = 0; i < n; i++)
    {
        for (int j = i + 1; j < n; j++)
        {
            for (int k = 0; k < n; k++)
            {
                if (stari_plan[i][k] && stari_plan[j][k])
                {
                    // std::cout << "t\n";
                    novi_plan[i][j] = true;
                    novi_plan[j][i] = true;
                    break;
                }
            }
        }
    }

    std::cout << pretraga();
    
    return 0;
}