#include <iostream>
#include <vector>
#include <queue>

using namespace std;

#define MAX_NODES 200001

struct Edge {
    int source;
    int destination;
};

struct Graph {
    vector<int> adjacencyList[MAX_NODES];
};

int bfs(Graph& graph, int start, int end) {
    queue<pair<int, int>> queue;
    queue.push({start, 0});

    vector<bool> visited(MAX_NODES, false);
    visited[start] = true;

    while (!queue.empty()) {
        int current = queue.front().first;
        int steps = queue.front().second;
        queue.pop();

        if (current == end) {
            return steps;
        }

        for (int neighbor : graph.adjacencyList[current]) {
            if (!visited[neighbor]) {
                queue.push({neighbor, steps + 1});
                visited[neighbor] = true;
            }
        }
    }

    return -1;
}

int minBuses(Graph& graph, int s, int t) {
    return bfs(graph, s, t);
}

int main() {
    int numNodes, numEdges, startNode, endNode;
    cin >> numNodes >> numEdges >> startNode >> endNode;

    Graph newPlan;

    for (int i = 0; i < numEdges; ++i) {
        int nodeU, nodeV;
        cin >> nodeU >> nodeV;
        newPlan.adjacencyList[nodeU].push_back(nodeV);
        newPlan.adjacencyList[nodeV].push_back(nodeU);
    }

    int result = minBuses(newPlan, startNode, endNode);

    cout << result/2 << endl;

    return 0;
}