using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        string[] prvaLinija = Console.ReadLine().Split(' ');
        int N = int.Parse(prvaLinija[0]);
        int M = int.Parse(prvaLinija[1]);
        int S = int.Parse(prvaLinija[2]);
        int T = int.Parse(prvaLinija[3]);

        Dictionary<int, List<int>> autobuskeLinije = new Dictionary<int, List<int>>();

        for (int i = 0; i < M; i++)
        {
            string[] linija = Console.ReadLine().Split(' ');
            int stanicaA = int.Parse(linija[0]);
            int stanicaB = int.Parse(linija[1]);

            if (!autobuskeLinije.ContainsKey(stanicaA))
                autobuskeLinije[stanicaA] = new List<int>();

            if (!autobuskeLinije.ContainsKey(stanicaB))
                autobuskeLinije[stanicaB] = new List<int>();

            autobuskeLinije[stanicaA].Add(stanicaB);
            autobuskeLinije[stanicaB].Add(stanicaA);
        }

        int brojAutobusa = PronadiBrojAutobusa(autobuskeLinije, S, T);

        Console.WriteLine(brojAutobusa);

        Console.ReadLine();
    }

    static int PronadiBrojAutobusa(Dictionary<int, List<int>> autobuskeLinije, int pocetnaStanica, int krajnjaStanica)
    {
        Queue<int> red = new Queue<int>();
        HashSet<int> poseceneStanice = new HashSet<int>();

        red.Enqueue(pocetnaStanica);
        poseceneStanice.Add(pocetnaStanica);

        int brojacAutobusa = 0;

        while (red.Count > 0)
        {
            int brojStanicaUTrenutnomAutobusu = red.Count;

            for (int i = 0; i < brojStanicaUTrenutnomAutobusu; i++)
            {
                int trenutnaStanica = red.Dequeue();

                if (trenutnaStanica == krajnjaStanica)
                {
                    return brojacAutobusa;
                }

                foreach (int susednaStanica in autobuskeLinije[trenutnaStanica])
                {
                    if (!poseceneStanice.Contains(susednaStanica))
                    {
                        red.Enqueue(susednaStanica);
                        poseceneStanice.Add(susednaStanica);
                    }
                }
            }

            brojacAutobusa++;
        }

        return -1;
    }
}