import java.util.*;
public class NoBuses {
    public static int molim_te_radi(Map<Integer, List<Integer>> graph, int brStanica, int startStanica, int destinacijaStanica) {
        Queue<Integer> queue = new LinkedList<>();
        Set<Integer> set = new HashSet<>();
        Map<Integer, Integer> busevi = new HashMap<>();
        queue.add(startStanica);
        set.add(startStanica);
        busevi.put(startStanica, 0);
        while (!queue.isEmpty()) {
            int trenutnaStanica = queue.poll();
            if (trenutnaStanica == destinacijaStanica) {
                return busevi.get(trenutnaStanica)/2;
            }
            for (int a : graph.getOrDefault(trenutnaStanica, Collections.emptyList())) {
                if (!set.contains(a)) {
                    queue.add(a);
                    set.add(a);
                    busevi.put(a, busevi.get(trenutnaStanica) + 1);
                }
            }
        }
        return -1;
    }
    public static void main(String[] args){
        Scanner in = new Scanner(System.in);
        int brStanica = in.nextInt();
        int brParova = in.nextInt();
        int startStanica = in.nextInt();
        int destinacijaStanica = in.nextInt();
        Map<Integer, List<Integer>> graph = new HashMap<>();
        for(int i = 0; i < brParova; i++){
            int Ui = in.nextInt();
            int Vi = in.nextInt();
            graph.putIfAbsent(Ui, new ArrayList<>());
            graph.putIfAbsent(Vi, new ArrayList<>());
            graph.get(Ui).add(Vi);
            graph.get(Vi).add(Ui);
        }
        System.out.println(molim_te_radi(graph, brStanica, startStanica, destinacijaStanica));
        in.close();
    }
}