#include <iostream>
#include <vector>
#include <unordered_map>
#include <queue>
#include <unordered_set>
using namespace std;

vector<int> bfs(const std::unordered_map<int, std::vector<int>>& graph, int start, int destination) {
    queue<vector<int>> q;
    unordered_set<int> visited;
    
    q.push({start});
    visited.insert(start);

    while (!q.empty()) {
        vector<int> path = q.front();
        q.pop();

        int current = path.back();

        if (current == destination) {
            return path;
        }

        for (int neighbor : graph.at(current)) {
            if (visited.find(neighbor) == visited.end()) {
                vector<int> newPath = path;
                newPath.push_back(neighbor);
                q.push(newPath);
                visited.insert(neighbor);
            }
        }
    }

    return {}; 
}


    int main() {

    int N,M,S,T;cin>>N>>M>>S>>T;
    
    vector<pair<int, int>> pairArray;
    for(int i=0; i<M;i++){
        int tmp1;cin>>tmp1;
        int tmp2;cin>>tmp2;
        
        pairArray.push_back(make_pair(tmp1, tmp2));
    }


    vector<pair<int, int>> newPairArray;


    for (int i = 0; i < pairArray.size()-1; ++i) {
        int commonElement;
        int firstElement1 = pairArray[i].first;
        int secondElement1 = pairArray[i].second;
        
    
        
        for (int j = i + 1; j < pairArray.size(); ++j) {
            int firstElement2 = pairArray[j].first;
            int secondElement2 = pairArray[j].second;
            
            
            if (firstElement1 == firstElement2 || firstElement1==secondElement2) {
                commonElement =firstElement1;
            } else if(secondElement1 == firstElement2 || secondElement1==secondElement2){
                commonElement = secondElement1;
            }
            
            pair<int, int> newPair;
            if (commonElement == firstElement1) {
                if(commonElement==firstElement2)newPair = make_pair(secondElement1, secondElement2);
                else if(commonElement==secondElement2) newPair= make_pair(secondElement1, firstElement2);
            } else  if( commonElement==secondElement1){
                if(commonElement==firstElement2)newPair = make_pair(firstElement1, secondElement2);
                else if(commonElement==secondElement2) newPair= make_pair(firstElement1, firstElement2);
            }   
            
            if (firstElement1 == firstElement2 || firstElement1 == secondElement2 ||
                secondElement1 == firstElement2 || secondElement1 == secondElement2) 
                newPairArray.push_back(newPair);
            
        }
    }
    
    
    std::unordered_map<int, std::vector<int>> graph;
    for (const auto& pair : newPairArray) {
        graph[pair.first].push_back(pair.second);
        graph[pair.second].push_back(pair.first);
    }
    
    int startVertex = S;
    int destinationVertex = T;

    
    vector<int> path = bfs(graph, startVertex, destinationVertex);

    cout<<path.size()-1;
    
}