using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        int N = int.Parse(Console.ReadLine());
        int M = int.Parse(Console.ReadLine());
        int S = int.Parse(Console.ReadLine());
        int T = int.Parse(Console.ReadLine());

        Dictionary<int, List<int>> connections = new Dictionary<int, List<int>>();
        
        for (int i = 0; i < M; i++)
        {
            string[] pair = Console.ReadLine().Split();
            int A = int.Parse(pair[0]);
            int B = int.Parse(pair[1]);

            if (!connections.ContainsKey(A))
                connections[A] = new List<int>();
            connections[A].Add(B);

            if (!connections.ContainsKey(B))
                connections[B] = new List<int>();
            connections[B].Add(A);
        }

        int minBuses = ShortestPath(connections, S, T);

        Console.WriteLine(minBuses);
    }

    static int ShortestPath(Dictionary<int, List<int>> connections, int start, int end)
    {
        Queue<int> queue = new Queue<int>();
        HashSet<int> visited = new HashSet<int>();
        Dictionary<int, int> distance = new Dictionary<int, int>();

        queue.Enqueue(start);
        visited.Add(start);
        distance[start] = 0;

        while (queue.Count > 0)
        {
            int currentStation = queue.Dequeue();

            if (connections.ContainsKey(currentStation))
            {
                foreach (int neighbor in connections[currentStation])
                {
                    if (!visited.Contains(neighbor))
                    {
                        queue.Enqueue(neighbor);
                        visited.Add(neighbor);
                        distance[neighbor] = distance[currentStation] + 1;

                        if (neighbor == end)
                        {
                            return distance[neighbor];
                        }
                    }
                }
            }
        }

        return -1;
    }
}