#include <iostream>
#include <vector>
#include <unordered_map>
#include <queue>
#include <algorithm>
#include <unordered_set>

using namespace std;

unordered_map<int, vector<int>> generisiRelacije(int m) {
    unordered_map<int, vector<int>> relacije;
    for (int i = 0; i < m; i++) {
        int num1, num2;
        cin >> num1 >> num2;
        if (relacije.find(num1) != relacije.end()) {
            relacije[num1].push_back(num2);
        }
        else {
            relacije[num1] = {num2};
        }
        if (relacije.find(num2) != relacije.end()) {
            relacije[num2].push_back(num1);
        }
        else {
            relacije[num2] = {num1};
        }
    }
    return relacije;
}

vector<pair<int, int>> nadjiZajednickeRelacije(unordered_map<int, vector<int>>& relacije) {
    vector<pair<int, int>> noveRelacije;
    for (auto it1 = relacije.begin(); it1 != relacije.end(); it1++) {
        for (auto it2 = relacije.begin(); it2 != relacije.end(); it2++) {
            int num1 = it1->first;
            int num2 = it2->first;
            if (num1 < num2 && any_of(it1->second.begin(), it1->second.end(), [&](int x) { return find(it2->second.begin(), it2->second.end(), x) != it2->second.end(); })) {
                noveRelacije.push_back(make_pair(num1, num2));
            }
        }
    }
    return noveRelacije;
}

int nadjiBrojRelacija(vector<pair<int, int>>& relacije, int pocetak, int kraj) {
    queue<pair<int, int>> red;
    red.push(make_pair(pocetak, 0));
    unordered_set<int> posecene;
    
    while (!red.empty()) {
        int node = red.front().first;
        int count = red.front().second;
        red.pop();
        
        if (node == kraj) {
            return count;
        }
        
        posecene.insert(node);
        
        for (auto it = relacije.begin(); it != relacije.end(); it++) {
            if (node == it->first && posecene.find(it->second) == posecene.end()) {
                red.push(make_pair(it->second, count + 1));
            }
        }
    }
    
    return -1;
}


int main() {
    int n, m, s, t;
    cin >> n >> m >> s >> t;
    
    unordered_map<int, vector<int>> relacije = generisiRelacije(m);
    vector<pair<int, int>> zajednickeRelacije = nadjiZajednickeRelacije(relacije);
    int brojRelacija = nadjiBrojRelacija(zajednickeRelacije, s, t);
    cout << brojRelacija << endl;
    
    return 0;
}