#include <iostream>
#include <vector>
#include <queue>

using namespace std;

int minBus(vector<vector<int>> & graph, int S, int T)
{
    vector<int> poseceno(graph.size(), 0);
    queue<int> q;
    q.push(S);
    poseceno[S] = 1;
    int bus = 0;
    while (!q.empty())
        {
            int size = q.size();
            while (size--)
            {
                int trenutno = q.front();
                q.pop();
                if (trenutno == T)
                {
                    return bus;
                }
                for (int neighbor : graph[trenutno])
                {
                    if (!poseceno[neighbor])
                    {
                        poseceno[neighbor] = 1;
                        q.push(neighbor);
                    }
                }
            }
            bus++;
        }
    return -1;
}
int main()
{
    int N, M, S, T;
    cin >> N >> M >> S >> T;
    vector<vector<int>> graph(N);
    for (int i = 0; i < M; i++)
    {
        int U, V;
        cin >> U >> V;
        graph[U - 1].push_back(V - 1);
        graph[V - 1].push_back(U - 1);
    }
    int result = minBus(graph, S - 1, T - 1);
    cout << result << endl;
    return 0;
}