#include <iostream>
#include <vector>
#include <queue>

using namespace std;

int findMinBuses(int N, int M, int S, int T, vector<vector<int>>& routes) {
    vector<vector<int>> graph(N + 1);

    // Creating the adjacency list for the original plan
    for (int i = 0; i < M; ++i) {
        int U = routes[i][0];
        int V = routes[i][1];
        graph[U].push_back(V);
        graph[V].push_back(U);
    }

    // BFS to find the minimum number of buses
    vector<int> visited(N + 1, 0);
    queue<pair<int, int>> q;
    q.push({S, 0});
    visited[S] = 1;

    while (!q.empty()) {
        int currentStation = q.front().first;
        int busesUsed = q.front().second;
        q.pop();

        if (currentStation == T) {
            return busesUsed;
        }

        for (int nextStation : graph[currentStation]) {
            if (!visited[nextStation]) {
                visited[nextStation] = 1;
                q.push({nextStation, busesUsed + 1});
            }
        }
    }

    // If destination is not reachable
    return -1;
}

int main() {
    int N, M, S, T;
    cin >> N >> M >> S >> T;

    vector<vector<int>> routes(M, vector<int>(2));

    for (int i = 0; i < M; ++i) {
        cin >> routes[i][0] >> routes[i][1];
    }

    int minBuses = findMinBuses(N, M, S, T, routes);

    cout << minBuses << endl;

    return 0;
}