#include <iostream>
#include <vector>
#include <unordered_map>
#include <unordered_set>
#include <queue>

using namespace std;

// Function to find the minimum number of transfers for the given route
int findMinTransfers(const unordered_map<string, vector<string>>& route, const string& start, const string& end) {
    unordered_set<string> visited;
    queue<pair<string, int>> q;
    
    q.push({start, 0});

    while (!q.empty()) {
        auto current = q.front();
        q.pop();

        if (current.first == end) {
            return current.second;
        }

        if (visited.find(current.first) == visited.end()) {
            visited.insert(current.first);

            for (const string& neighbor : route.at(current.first)) {
                q.push({neighbor, current.second + 1});
            }
        }
    }

    return -1; // If no route is found
}

int main() {
    int N; // Number of stations
    cin >> N;

    unordered_map<string, vector<string>> route;

    // Read the routes
    for (int i = 0; i < N; ++i) {
        string A, B;
        cin >> A >> B;

        route[A].push_back(B);
        route[B].push_back(A);
    }

    string start, end;
    cin >> start >> end;

    int minTransfers = findMinTransfers(route, start, end);
    
    cout << minTransfers << endl;

    return 0;
}