#include <iostream>
#include <vector>
#include <unordered_map>
#include <unordered_set>
#include <queue>

using namespace std;

int findMinTransfers(const unordered_map<string, vector<string>>& route, const string& start, const string& end) {
    unordered_set<string> visited;
    queue<pair<string, int>> q;

    q.push({start, 0});

    while (!q.empty()) {
        auto current = q.front();
        q.pop();

        if (current.first == end) {
            return current.second;
        }

        if (visited.find(current.first) == visited.end()) {
            visited.insert(current.first);

            for (const string& neighbor : route.at(current.first)) {
                // Modify the condition to check if it's a new line
                if (neighbor != end && route.at(neighbor).size() == 1) {
                    q.push({neighbor, current.second + 1});
                }
            }
        }
    }

    return -1; // If no route is found
}

int main() {
    int N;
    cin >> N;

    unordered_map<string, vector<string>> route;

    for (int i = 0; i < N; ++i) {
        string A, B;
        cin >> A >> B;

        route[A].push_back(B);
        route[B].push_back(A);
    }

    string start, end;
    cin >> start >> end;

    int minTransfers = findMinTransfers(route, start, end);

    cout << minTransfers << endl;

    return 0;
}