#include <iostream>
#include <vector>
#include <queue>
#include <unordered_set>

using namespace std;

int main() {
    int N, M, S, T;
    cin >> N >> M >> S >> T;

    vector<vector<int>> adj(N + 1); // Adjacency list for the bus stops
    vector<int> buses(N + 1, -1);   // Stores the bus number for each stop
    unordered_set<int> transitStops; // Set to store stops that act as transit points

    for (int i = 0; i < M; ++i) {
        int U, V;
        cin >> U >> V;
        adj[U].push_back(V);
        adj[V].push_back(U);
        transitStops.insert(U);
        transitStops.insert(V);
    }

    queue<int> q;
    q.push(S);
    buses[S] = 0; // The starting stop is served by bus number 0

    while (!q.empty()) {
        int currentStop = q.front();
        q.pop();

        for (int nextStop : adj[currentStop]) {
            if (buses[nextStop] == -1) {
                buses[nextStop] = buses[currentStop] + 1;
                q.push(nextStop);
            }
        }
    }

    // Adjust the number of transfers based on transit stops
    int minBuses = buses[T] - transitStops.count(T);

    cout << minBuses << endl; // Output the minimum number of buses needed
    return 0;
}