from collections import defaultdict, deque

def min_buses(N, M, S, T, connections):

    graph = defaultdict(list)
    for u, v in connections:
        graph[u].append(v)
        graph[v].append(u)


    def bfs(start, end):
        visited = set()
        queue = deque([(start, 0)]) 
        
        while queue:
            current, buses = queue.popleft()
            if current == end:
                return buses
            visited.add(current)
            
            for neighbor in graph[current]:
                if neighbor not in visited:
                    queue.append((neighbor, buses + 1))
                    visited.add(neighbor)
        
        return 


    result = bfs(S, T)
    return result


N, M, S, T = map(int, input().split())
connections = [tuple(map(int, input().split())) for _ in range(M)]


result = min_buses(N, M, S, T, connections)
print(result)