#include <iostream>
#include <vector>

int findMinCostPath(std::vector<int>& nums) {
    int n = nums.size();
    
    for (int i = 2; i < n; ++i) {
        nums[i] += std::min(nums[i - 1], nums[i - 2]);
    }
    
    return std::min(nums[n - 1], nums[n - 2]);
}

int main() {
    int numElements;
    std::cin >> numElements;

    std::vector<int> originalArr(numElements);
    for (int i = 0; i < numElements; ++i) {
        std::cin >> originalArr[i];
    }

    int numPlayers;
    std::cin >> numPlayers;

    std::vector<std::vector<int>> removals(numPlayers, std::vector<int>(2));
    for (int i = 0; i < numPlayers; ++i) {
        for (int j = 0; j < 2; ++j) {
            std::cin >> removals[i][j];
            removals[i][j] -= 1;
        }
    }

    std::vector<int> arr(originalArr);

    if (numElements < 2) {
        std::cout << "0\n";
    } else {
        for (int i = 0; i < numPlayers; ++i) {
            for (int j = 0; j < 2; ++j) {
                arr[removals[i][j]] = 0;
            }

            std::vector<int> arrAfterRemoval;
            for (int j = 0; j < numElements; ++j) {
                if (arr[j] != 0) {
                    arrAfterRemoval.push_back(arr[j]);
                }
            }

            if (arrAfterRemoval.size() < 2) {
                std::cout << "0\n";
            } else {
                int result = findMinCostPath(arrAfterRemoval);
                std::cout << result << std::endl;
            }
        }
    }

    return 0;
}