#include <iostream>
#include <vector>

using namespace std;

vector<int> minimalniSkor(int N, vector<int>& A, int Q, vector<pair<int, int>>& smicalice) {
    vector<int> skorovi;
    int trenutniSkor = accumulate(A.begin(), A.end(), 0);

    for (int i = 0; i < Q; i++) {
        int L = smicalice[i].first - 1;  // Smanjujemo za 1 zbog indeksiranja u C++
        int R = smicalice[i].second - 1;

        // Racunamo skor pre brisanja elemenata
        int preBrisanja = trenutniSkor - ((L > 0) ? A[L - 1] : 0) - ((R < N - 1) ? A[R + 1] : 0);

        // Racunamo skor nakon brisanja elemenata
        int posleBrisanja = preBrisanja;
        for (int j = L; j <= R; j++) {
            posleBrisanja -= A[j];
        }

        // Dodajemo razliku u skoru u rezultate
        skorovi.push_back(preBrisanja - posleBrisanja);

        // Ažuriramo trenutni skor za narednu iteraciju
        trenutniSkor = posleBrisanja;
    }

    return skorovi;
}

int main() {
    int N;
    cin >> N;

    vector<int> A(N);
    for (int i = 0; i < N; i++) {
        cin >> A[i];
    }

    int Q;
    cin >> Q;

    vector<pair<int, int>> smicalice(Q);
    for (int i = 0; i < Q; i++) {
        cin >> smicalice[i].first >> smicalice[i].second;
    }

    // Poziv funkcije i ispis rezultata
    vector<int> rezultati = minimalniSkor(N, A, Q, smicalice);
    for (int rezultat : rezultati) {
        cout << rezultat << endl;
    }

    return 0;
}