#include<iostream>
#include<cmath>
#include<algorithm>
#include <limits.h>
using namespace std;
int minDistance(int* dist, bool *done, int n){
 
    int min = INT_MAX, min_index;
 
    for (int v = 0; v < n; v++)
        if (done[v] == false && dist[v] <= min)
            min = dist[v], min_index = v;
 
    return min_index;
}
 

void printSolution(int *dist, int n){
    for (int i = 0; i < n; i++){
    	cout << i << " \t\t\t\t" << dist[i] << endl;
	}
}
void dijkstra(long int **graph, int src, int *dist, int n){

    bool *done = new bool[n];    
    
    for (int i = 0; i < n; i++)
        dist[i] = INT_MAX, done[i] = false;
 
    dist[src] = 0;
   
    for (int count = 0; count < n - 1; count++) {
        
        int u = minDistance(dist, done,n);
 
        done[u] = true;
 
        for (int v = 0; v < n; v++)
            if (!done[v] && graph[u][v]
                && dist[u] != INT_MAX
                && dist[u] + graph[u][v] < dist[v])
                dist[v] = dist[u] + graph[u][v];
    }
    
    delete[] done;
    
}
int main(){
	int n, q;
	cin>>n;
	long a[n];
	for(int i=0; i<n; i++){
		cin>>a[i];
	}
	
	cin>>q;
	int l[q],r[q];
	for(int i=0; i<q; i++){
		cin>>l[i]>>r[i];
	}
	
	long int **mat = new long*[n+2];
	
	for(int i=0; i<n+2; i++)
		mat[i] = new long[n+2]{0};

	for(int i=0; i<n+1; i++){
		mat[i][i+1]=a[i];
		mat[i][i+2]=a[i+1];
	}
	mat[n][n+1]=0;
	mat[n-1][n+1]=0;
	
	int *distance=new int[n+2];
	
	
	
	int temp1, temp2;
	for(int i=0; i<q; i++){//Ali-2, Ali-1
		
		mat[l[i]-1][r[i]+1]=a[r[i]+1-1];
		mat[l[i]-2][r[i]+1]=a[r[i]+1-1];
		/*for(int y=0; y<n+2; y++){
			for(int x=0; x<n+2; x++){
				cout<<mat[y][x]<< " ";
			}
			cout<<endl;
		}*/
		dijkstra((long int**)mat, 0, distance, n+2);
		
		mat[l[i]-1][r[i]+1]=0;
		mat[l[i]-2][r[i]+1]=0;
		int max = (distance[n]<distance[n-1]?distance[n]:distance[n-1]);
		cout<<max<<endl;
	}
	
	
	
	
	for(int i=0; i<n+2; i++){
		delete[] mat[i];
	}
	delete[] mat;
	delete[] distance;
	return 0;
}