using System;
using System.Text;
using System.Linq;
using System.Collections.Generic;

public class Program
{
    
    static void ReadValues(ref int[] vals, string str, StringBuilder sb)
    {
      int counter = 0;
      foreach(char c in str)
      {
        if (c!=' ') sb.Append(c);
        else
        {
          vals[counter] = int.Parse(sb.ToString());
          counter++;
          sb.Clear();
        }
      }
      vals[counter] = int.Parse(sb.ToString());
      sb.Clear();
    }
    
    static void ReadQLines(int q, ref Tuple<int,int>[] tupleArray, StringBuilder sb)
    {
      for(int i = 0; i<q; i++)
      {
        string str = Console.ReadLine();
        int[] temp = new int[2];
        ReadValues(ref temp, str, sb);
        tupleArray[i] = new Tuple<int,int>(temp[0]-1,temp[1]-1);
      }
    }
    
    static List<int>[] CreateQPaths(int q, int[] path, ref Tuple<int,int>[] tupleArray)
    {
      List<int>[] paths = new List<int>[q];
      for(int i = 0; i<q; i++)
      {
        paths[i] = new List<int>();
        for(int j = 0; j<path.Length;j++)
        {
          if(j < tupleArray[i].Item1 || j > tupleArray[i].Item2)
          {
            paths[i].Add(path[j]);
          }
        }
      }
      return paths;
    }
    static int AllPossible(List<int> path, int startIndex, int minSum)
    {
      minSum += path[startIndex];
      List<int> nextStep = new List<int>();
      
      bool canPlusOne = startIndex+1 < path.Count;
      bool canPlusTwo = startIndex+2 < path.Count;
      
      if(!canPlusOne||!canPlusTwo)
      {
        return minSum;
      }
      
      for(int i = startIndex+1; i< path.Count; i++)
      {
        nextStep.Add(path[i]);
      }
      
      return AllPossible(nextStep,0, minSum) < AllPossible(nextStep,1, minSum) ?
                AllPossible(nextStep,0, minSum):AllPossible(nextStep,1, minSum);
    }
    
    static void PlayQGames(int q, List<int>[] paths)
    {
      int minSum = 0;
      for(int i = 0; i<q; i++)
      {
        if(!paths[i].Any() || paths[i].Count == 1)
        {
          Console.WriteLine(0);
          return;
        }
        minSum = AllPossible(paths[i],0, 0) < AllPossible(paths[i],1, 0) ?
                    AllPossible(paths[i],0, 0):AllPossible(paths[i],1, 0);
        Console.WriteLine(minSum);
      }
    }
    
    static void Main(string[] args)
    {
        int n = int.Parse(Console.ReadLine());
        int[] mainPath = new int[n];
        
        string str = Console.ReadLine();
        StringBuilder sb = new StringBuilder();
        ReadValues(ref mainPath, str, sb);
        
        int q = int.Parse(Console.ReadLine());
        Tuple<int,int>[] removedValsByRound = new Tuple<int,int>[q];
        
        ReadQLines(q, ref removedValsByRound, sb);
        List<int>[] paths = CreateQPaths(q, mainPath, ref removedValsByRound);
        PlayQGames(q, paths);
        
    }
}