#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int minSum(vector<int>& arr) {
    int n = arr.size();
    if (n == 0) return 0;
    if (n == 1) return arr[0];
    if (n == 2) return min(arr[0], arr[1]);
    vector<int> dp(n, 0);
    dp[n-1] = arr[n-1];
    dp[n-2] = arr[n-2];
    for (int i = n - 3; i >= 0; i--) {
        dp[i] = arr[i] + min(dp[i+1], dp[i+2]);
    }
    return min(dp[0], dp[1]);
}

int main() {
    int n;
    cin >> n;
    vector<int> arr(n);
    for (int i = 0; i < n; ++i) cin >> arr[i];
    int q;
    cin >> q;
    vector<int> l(q);
    vector<int> r(q);
    for (int i = 0; i < q; ++i) cin >> l[i] >> r[i];
    for (int i = 0; i < q; ++i) {
        vector<int> subArr;
        for (int j = 0; j < n; ++j) {
            if (j < l[i] - 1 || j > r[i] - 1) {
                subArr.push_back(arr[j]);
            }
        }
        cout << minSum(subArr) << endl;
    }
    return 0;
}