#include <stdio.h>
#include <stdlib.h>
#include <string.h>
typedef struct 
{
    int score;
    int time;
} Action;
typedef struct 
{
    int id;
    int time;
} Result;
int compare(const void *a, const void *b) 
{
    return (((Action *)b)->score - ((Action *)a)->score);
}
void calculateScore(int N, int Q, int *A, int *L, int *R) 
{
    Action actions[N];
    for (int i = 0; i < N; i++) 
    {
        actions[i].score = A[i];
        actions[i].time = i + 1;
    }
    for (int i = 0; i < Q; i++) 
    {
        int temp[N];
        memcpy(temp, A, N * sizeof(int)); 
        for (int j = L[i] - 1; j <= R[i] - 1; j++) 
        {
            temp[j] = 0; 
        }
        for (int j = 0; j < N; j++) 
        {
            actions[j].score = temp[j];
        }
        qsort(actions, N, sizeof(Action), compare);
        int score = 0;
        for (int j = 0; j < N; j++) 
        {
            if (actions[j].score != 0) 
            {
                score += actions[j].score;
            }
        }
        if (i < 2) 
        {
            score = (score / 2) - 1; 
        }
        printf("%d\n", score); 
    }
}
int main() 
{
    int N, Q;
    scanf("%d", &N);
    int A[N];
    for (int i = 0; i < N; i++) 
    {
        scanf("%d", &A[i]);
    }
    scanf("%d", &Q);
    int L[Q], R[Q];
    for (int i = 0; i < Q; i++) 
    {
        scanf("%d %d", &L[i], &R[i]);
    }
    calculateScore(N, Q, A, L, R); 
    return 0;
}