#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int minPoints(const vector<int>& arr) {
    int n = arr.size();
    if (n <= 1) {
        return 0;
    }
    vector<int> dp(n, 0);
    dp[n - 1] = arr[n - 1];
    dp[n - 2] = arr[n - 2];
    for (int i = n - 3; i >= 0; --i) {
        dp[i] = arr[i] + min(dp[i + 1], dp[i + 2]);
    }
    return min(dp[0], dp[1]);
}
int main() {
    int N;
    cin >> N;
    vector<int> A(N);
    for (int i = 0; i < N; ++i) {
        cin >> A[i];
    }
    int Q;
    cin >> Q;
    for (int q = 0; q < Q; ++q) {
        int L, R;
        cin >> L >> R;

        vector<int> B;
        if (L == 1 && R == N) {
            cout << "0\n";
            continue;
        }
        else if (L == 1) {
            B = vector<int>(A.begin() + R, A.end());
        }
        else if (R == N) {
            B = vector<int>(A.begin(), A.begin() + L - 1);
        }
        else {
            B = vector<int>(A.begin(), A.begin() + L - 1);
            B.insert(B.end(), A.begin() + R, A.end());
        }
        int result = minPoints(B);
        cout << result << endl;
    }
}