#include <iostream>
#include <vector>
#include <deque>
#include <algorithm>

using namespace std;

int minResult(vector<int> a) {
    vector<int> dp(a.size());
    dp[0] = a[0];
    dp[1] = a[1];
    deque<int> q{0, 1};
    for (int i = 2; i < a.size(); i++) {
        while (!q.empty() && q.front() < i - 2) {
            q.pop_front();
        }
        dp[i] = a[i] + dp[q.front()];
        while (!q.empty() && dp[q.back()] >= dp[i]) {
            q.pop_back();
        }
        q.push_back(i);
    }
    return min(dp[a.size() - 1], dp[a.size() - 2]);
}

int main() {
    cin.tie(0);
    int n, q;
    cin >> n;
    vector<int> a(n);
    for (int i = 0; i < n; i++) {
        cin >> a[i];
    }
    cin >> q;
    for (int i = 0; i < q; i++) {
        int l, r;
        cin>>l>>r;
        vector<int> a2 = a;
        a2.erase(a2.begin() + l-1, a2.begin() + r);
        if(a2.size()==0) {cout<<0;continue;}
        cout << minResult(a2) << endl;
    }
    return 0;
}