using System;
using System.Text;

class Program
{
    static int MinimalniSkor(int n, int[] niz, int pocetak, int kraj)
    {
        int pretprethodni = 0;
        int prethodni = 0;

        for (int i = 0; i < n; i++)
        {
            if (i < pocetak || i > kraj)
            {
                int trenutni = niz[i] + Math.Min(pretprethodni, prethodni);
                pretprethodni = prethodni;
                prethodni = trenutni;
            }
        }

        return Math.Min(pretprethodni, prethodni);
    }

    static void Main()
    {
        var duzinaNiza = int.Parse(Console.ReadLine());
        var niz = Array.ConvertAll(Console.ReadLine().Split(' '), int.Parse);

        var brojUpita = int.Parse(Console.ReadLine());
        var izlaz = new StringBuilder();

        for (int i = 0; i < brojUpita; i++)
        {
            var upit = Console.ReadLine().Split(' ');
            var pocetak = int.Parse(upit[0]) - 1;
            var kraj = int.Parse(upit[1]) - 1;

            izlaz.Append(MinimalniSkor(duzinaNiza, niz, pocetak, kraj));
            izlaz.Append('\n');
        }

        Console.Write(izlaz);
    }
}