#include <iostream>
#include <vector>
#include <climits>

int findMinSum(const std::vector<int>& arr) {
    int n = arr.size();
    if (n == 0) return 0;
    if (n == 1) return arr[0];

    std::vector<int> dp(n, INT_MAX);
    dp[0] = arr[0];
    dp[1] = arr[1];

    for (int i = 2; i < n; i++) {
        dp[i] = std::min(dp[i - 1], dp[i - 2]) + arr[i];
    }

    return std::min(dp[n - 1], dp[n - 2]);
}

int main() {
    int n;
    std::cin >> n;
    std::vector<int> v(n);
    for(int i = 0; i < n; i++) {
        std::cin >> v[i];
    }

    int q;
    std::cin >> q;

    std::vector<std::vector<int>> queries(q);
    for (int i = 0; i < q; i++) {
        int left, right;
        std::cin >> left >> right;
        queries[i] = {left, right};
    }

    std::vector<int> results;
    for (int i = 0; i < q; i++) {
        int left = queries[i][0], right = queries[i][1];

        std::vector<int> a = v;
        a.erase(a.begin() + left - 1, a.begin() + right);

        int result = findMinSum(a);
        results.push_back(result);
    }

    for (int i = 0; i < q; i++) {
        std::cout << results[i] << std::endl;
    }

    return 0;
}