#include <iostream>
#include <vector>
#include <algorithm>

int calculateMinCostPath(std::vector<int>& numbers) {
    int size = numbers.size();
    for (int i = 2; i < size; ++i) {
        numbers[i] += std::min(numbers[i - 1], numbers[i - 2]);
    }

    return std::min(numbers[size - 1], numbers[size - 2]);
}

int main() {
    int numElements;
    std::cin >> numElements;

    std::vector<int> originalArray(numElements);
    for (int i = 0; i < numElements; ++i) {
        std::cin >> originalArray[i];
    }

    int numPlayers;
    std::cin >> numPlayers;

    std::vector<std::vector<int>> removals(numPlayers);
    for (int i = 0; i < numPlayers; ++i) {
        removals[i].resize(2);
        for (int j = 0; j < 2; ++j) {
            std::cin >> removals[i][j];
            removals[i][j] -= 1; // Adjust index to start from 0
        }
    }

    std::vector<int> modifiedArray = originalArray;

    if (modifiedArray.size() < 2) {
        std::cout << 0 << std::endl;
    } else {
        for (int i = 0; i < numPlayers; ++i) {
            for (int index : removals[i]) {
                modifiedArray[index] = 0;
            }

            std::vector<int> arrayAfterRemoval;
            for (int num : modifiedArray) {
                if (num != 0) {
                    arrayAfterRemoval.push_back(num);
                }
            }

            if (arrayAfterRemoval.size() < 2) {
                std::cout << 0 << std::endl;
            } else {
                int result = calculateMinCostPath(arrayAfterRemoval);
                std::cout << result << std::endl;
            }
        }
    }

    return 0;
}