using System;
using System.Linq;

class Program
{
    static int CalculateScore(int[] arr)
    {
        int n = arr.Length;
        int[] dp = new int[n + 2];
        dp[n] = dp[n + 1] = 0;
        for (int i = n - 1; i >= 0; i--)
        {
            dp[i] = arr[i] + Math.Min(dp[i + 1], dp[i + 2]);
        }

        return dp[0];
    }

    static int SolveQuery(int[] arr, int l, int r)
    {
        l--; 
        r--;
        var subarray = arr.Skip(l).Take(r - l + 1).ToArray();
        arr = arr.Take(l).Concat(arr.Skip(r + 1)).ToArray();
        int score = CalculateScore(arr);
        arr = arr.Take(l).Concat(subarray).Concat(arr.Skip(l)).ToArray();

        return score;
    }

    static void Main()
    {
        int N = int.Parse(Console.ReadLine());
        int[] A = Console.ReadLine().Split().Select(int.Parse).ToArray();
        int Q = int.Parse(Console.ReadLine());
        var queries = new int[Q][];
        for (int i = 0; i < Q; i++)
        {
            queries[i] = Console.ReadLine().Split().Select(int.Parse).ToArray();
        }
        var results = new int[Q];
        for (int i = 0; i < Q; i++)
        {
            results[i] = SolveQuery(A, queries[i][0], queries[i][1]);
        }
        foreach (var result in results)
        {
            Console.WriteLine(result);
        }
    }
}