using System;
using System.Linq;

class Program
{
    static void Main()
    {
        // Ucitavanje velicine niza A
        int N = int.Parse(Console.ReadLine());

        // Ucitavanje elemenata niza A
        int[] A = Console.ReadLine().Split().Select(int.Parse).ToArray();

        // Ucitavanje broja Pericinih drugova
        int Q = int.Parse(Console.ReadLine());

        // Inicijalizacija niza B
        int[] B = new int[N];
        Array.Copy(A, B, N);

        // Ucitavanje i obrada svakog druga
        for (int i = 0; i < Q; i++)
        {
            // Ucitavanje L i R za i-tog druga
            string[] input = Console.ReadLine().Split();
            int Li = int.Parse(input[0]);
            int Ri = int.Parse(input[1]);

            // Kopiranje elemenata koji ce biti obrisanu iz niza B
            int[] removedElements = B.Skip(Li - 1).Take(Ri - Li + 1).ToArray();

            // Brisanje elemenata iz niza B
            B = B.Take(Li - 1).Concat(B.Skip(Ri)).ToArray();

            // Racunanje i ispis minimalnog skora
            long minScore = CalculateMinScore(B);
            Console.WriteLine(minScore);

            // Vracanje obrisanih elemenata u niz B
            B = B.Take(Li - 1).Concat(removedElements).Concat(B.Skip(Li - 1)).ToArray();
        }
    }

    // Pomocna funkcija za racunanje minimalnog skora
    static long CalculateMinScore(int[] array)
    {
        long score = 0;
        int n = array.Length;

        for (int i = 0; i < n; i += 2)
        {
            score += array[i];
        }

        return score;
    }
}