#include <stdio.h>
#include <stdlib.h>

struct node{ // Node u linked list-u
  int data;
  struct node *link;
};

struct node* add_at_end(struct node *ptr, int data){ // Dodavanje node-a na kraju linked list-a
  struct node *temp = malloc(sizeof(struct node));
  temp -> data = data;
  temp -> link = NULL;
  ptr -> link = temp;
  return temp;
}

void delete(struct node **head, int l, int d) { // Uklonjavanje vise node-ova u linked listu, od node-a l, do node-a d
    if(l == 1){
        struct node *current = (*head) -> link;
        while(d > 0){
            free(*head);
            *head = current;
            current = current -> link;
            d--;
        }
    }
    else{
        struct node *levo = *head;
        int del_count = d - l;
    
        while(l > 2){
            levo = levo -> link;
            l--;
        }
        struct node *current = levo -> link;
        struct node *previous = levo -> link;

        while(del_count >= 0){
            current = current -> link;
            free(previous);
            previous = current;
            del_count--;
        }
        levo -> link = current;
        previous = NULL;
        current = NULL;
    }
}

int main() {    
    int n, q;
    scanf("%d", &n);
    int *brojevi = malloc(n * sizeof(int)); // Ucitavanje originalnih brojevi u skolici
    
    for(int i = 0; i < n; i++){
        scanf("%d", &brojevi[i]); 
    }

    scanf("%d", &q);
    q *= 2;

    int *drugovi = malloc(q * sizeof(int)); // Ucitavanje drugova
    for(int i = 0; i < q; i++){
        scanf("%d", &drugovi[i]);
    }
    for(int i = 0; i < (q - 1); i += 2){
        if(drugovi[i] == 1 && drugovi[i + 1] == n){
            printf("0");
            continue;
        }
        struct node *head = malloc(sizeof(struct node));
        head -> data = brojevi[0];
        head -> link = NULL;
        
        struct node *ptr = head;
        for(int j = 1; j < n; j++){
            ptr = add_at_end(ptr, brojevi[j]);
        }

        delete(&head, drugovi[i], drugovi[i + 1]); // Brisanje polja u skolici
        if(head -> link == NULL){
            printf("0");
            continue;
        }
        int first = head -> data; // Pronalazenje najmanje moguce sume
        int second = head -> link -> data;

        struct node *current = head->link->link;

        while (current != NULL) {
            int temp = second;
            second = current->data + (second < first ? second : first);
            first = temp;
            current = current->link;
        }
        int sum = first < second ? first : second;
        printf("%d\n", sum);
    }

    return 0;
}