#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

long long minCostToJump(const vector<long long>& nums) {
    int n = nums.size();


    if (n < 2) {
        return 0;
    }
    else if(n==2){
        return min(nums[0],nums[1]);
    }


    // Initialize an array to store the minimum cost to reach each position
    vector<long long> minCost(n, 0);

    // Base cases
    minCost[0] = nums[0];
    minCost[1] = nums[1];

    // Iterate through the vector and calculate the minimum cost at each position
    for (int i = 2; i < n; ++i) {
        minCost[i] = nums[i] + min(minCost[i - 1], minCost[i - 2]);
    }

    // The minimum cost is the minimum of the last two positions
    return min(minCost[n - 1], minCost[n - 2]);
}


int main() {

    int N,Q;
       cin >>N;
    vector<long long> originalVector(N);


    for(int i=0; i<N; i++){
        cin>>originalVector[i];
    }

    cin >>Q;
    vector<int> startIndex(Q);
    vector<int> endIndex(Q);

   for(int i=0; i<Q; i++){
        cin>>startIndex[i];
        cin>>endIndex[i];
    }

       for(int i=0; i<Q; i++){


    // Isecanje dela od pocetka do indeksa prvi
    std::vector<long long> deo_prvi(originalVector.begin(), originalVector.begin() + startIndex[i]-1);

    // Isecanje dela od indeksa drugi do kraja
    std::vector<long long> deo_drugi(originalVector.begin() + endIndex[i], originalVector.end());

    // Nadovezivanje delova
    std::vector<long long> novi_vektor;
    novi_vektor.insert(novi_vektor.end(), deo_prvi.begin(), deo_prvi.end());
    novi_vektor.insert(novi_vektor.end(), deo_drugi.begin(), deo_drugi.end());



   cout << minCostToJump(novi_vektor) << "\n";
 //   for(int j=0; j<novi_vektor.size();j++){
 //       cout<<novi_vektor[j];
 //   }
//    cout<<"\n";

    }

    return 0;
}