using System;
using System.Linq;

class Program
{
    static int CalculateMinScore(int[] array)
    {
        int n = array.Length;
        int[] dp = new int[n + 1];

        dp[0] = 0;
        dp[1] = array[0];

        for (int i = 2; i <= n; i++)
        {
            dp[i] = Math.Min(dp[i - 1], dp[i - 2]) + array[i - 1];
        }

        return dp[n];
    }

    static void Main()
    {
        int N = int.Parse(Console.ReadLine());
        int[] array = Console.ReadLine().Split().Select(int.Parse).ToArray();

        int Q = int.Parse(Console.ReadLine());
        for (int i = 0; i < Q; i++)
        {
            string[] LR = Console.ReadLine().Split();
            int L = int.Parse(LR[0]);
            int R = int.Parse(LR[1]);

            int[] modifiedArray = array.Skip(L - 1).Take(R - L + 1).ToArray();
            int minScore = CalculateMinScore(modifiedArray);

            Console.WriteLine(minScore);
        }
    }
}