#include <iostream>

    #include <vector>
    #include <algorithm>

    using namespace std;

    int calculateMinScore(vector<int>& arr) {
        int n = arr.size();
        if (n <= 2) return 0;

        vector<int> dp(n, 0);
        dp[1] = abs(arr[1] - arr[0]);

        for (int i = 2; i < n; ++i) {
            dp[i] = min(dp[i - 1] + abs(arr[i] - arr[i - 1]), dp[i - 2] + abs(arr[i] - arr[i - 2]));
        }

        return dp[n - 1];
    }

    int main() {
        int N;
        cin >> N;

        vector<int> A(N);
        for (int i = 0; i < N; ++i) {
            cin >> A[i];
        }

        int Q;
        cin >> Q;

        while (Q--) {
            int L, R;
            cin >> L >> R;

            vector<int> B;
            for (int i = 0; i < L - 1; ++i) {
                B.push_back(A[i]);
            }
            for (int i = R; i < N; ++i) {
                B.push_back(A[i]);
            }

            int minScore = calculateMinScore(B);
            cout << minScore << endl;
        }

        return 0;
    }