using System;
using System.Collections.Generic;

class Program {
    static int CalculateMinimumScore(int[] B) {
        int n = B.Length;
        int[] dp = new int[n + 2];
        dp[0] = 0;
        dp[1] = 0;

        for (int i = 2; i <= n + 1; i++) {
            dp[i] = Math.Min(dp[i - 1] + (i - 2 < n ? B[i - 2] : 0), 
                             dp[i - 2] + (i - 2 < n ? B[i - 2] : 0));
        }

        return dp[n + 1];
    }

    static void Main() {
        int N = int.Parse(Console.ReadLine());
        int[] A = Array.ConvertAll(Console.ReadLine().Split(' '), int.Parse);
        int Q = int.Parse(Console.ReadLine());

        for (int q = 0; q < Q; q++) {
            int[] L_R = Array.ConvertAll(Console.ReadLine().Split(' '), int.Parse);
            int L = L_R[0] - 1;
            int R = L_R[1] - 1;

            List<int> B = new List<int>();
            B.AddRange(A[0..L]);
            B.AddRange(A[(R + 1)..N]);

            Console.WriteLine(CalculateMinimumScore(B.ToArray()));
        }
    }
}