import java.util.Scanner;

public class Skolice {

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        // Ucitavanje velicine niza A
        int n = scanner.nextInt();

        // Ucitavanje elemenata niza A
        int[] a = new int[n];
        for (int i = 0; i < n; i++) {
            a[i] = scanner.nextInt();
        }

        // Ucitavanje broja drugova Q
        int q = scanner.nextInt();

        // Prolazak kroz svakog druga
        for (int i = 0; i < q; i++) {
            // Ucitavanje informacija o smicalici
            int l = scanner.nextInt();
            int r = scanner.nextInt();

            // Racunanje minimalnog skora za datu smicalicu
            int minScore = calculateMinScore(a, l, r);

            // Ispis rezultata za trenutnu smicalicu
            System.out.println(minScore);
        }
    }

    // Metoda za racunanje minimalnog skora za datu smicalicu
    private static int calculateMinScore(int[] a, int l, int r) {
        // Inicijalizacija niza za dinamicko programiranje
        int[] dp = new int[a.length + 1];

        // Prolazak kroz niz a
        for (int i = 1; i <= a.length; i++) {
            // Postavljanje pocetne vrednosti dp niza
            dp[i] = dp[i - 1] + a[i - 1];

            // Ako se trenutna pozicija nalazi unutar opsega smicalice, ažuriraj dp vrednost
            if (i >= l && i <= r) {
                dp[i] = Math.min(dp[i], dp[i - l]);
            }

            // Ako se trenutna pozicija nalazi izvan opsega smicalice, ažuriraj dp vrednost
            if (i > r) {
                dp[i] = Math.min(dp[i], dp[i - l] + dp[i - r]);
            }
        }

        // Vracanje minimalnog skora za poslednju poziciju
        return dp[a.length];
    }
}