#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);

    int N;
    cin >> N;

    vector<int> A(N);
    for (int i = 0; i < N; i++) {
        cin >> A[i];
    }

    int Q;
    cin >> Q;

    for (int q = 0; q < Q; q++) {
        int L, R;
        cin >> L >> R;

        // Pravljenje niza za igru bez izbacenih elemenata
        vector<int> gameArray;
        for (int i = 0; i < N; i++) {
            if (i < L - 1 || i >= R) {
                gameArray.push_back(A[i]);
            }
        }

        // Dinamicko programiranje za racunanje minimalnog skora
        vector<int> dp(N + 1, 1e9);  // Inicijalizacija sa velikom vrednošcu
        dp[0] = 0;

        for (int i = 1; i <= N; i++) {
            dp[i] = min(dp[i], dp[i - 1] + gameArray[i - 1]);
            if (i < N) {
                dp[i + 1] = min(dp[i + 1], dp[i - 1] + gameArray[i - 1]);
            }
        }

        cout << dp[N] << endl;
    }

    return 0;
}