using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        // Citanje ulaza
        int N = int.Parse(Console.ReadLine());
        int[] A = Console.ReadLine().Split().Select(int.Parse).ToArray();
        int Q = int.Parse(Console.ReadLine());

        // Inicijalizacija promenljivih za rešenje
        int[] result = new int[Q];

        // Petlja kroz svaki upit
        for (int i = 0; i < Q; i++)
        {
            // Citanje podataka za trenutni upit
            int[] query = Console.ReadLine().Split().Select(int.Parse).ToArray();
            int Li = query[0];
            int Ri = query[1];

            // Kreiranje niza za igru na osnovu smicalice i izracunavanje minimalnog skora
            int[] gameArray = CreateGameArray(A, Li, Ri);
            int minScore = CalculateMinScore(gameArray);

            // Cuvanje rezultata
            result[i] = minScore;
        }

        // Ispis rezultata
        foreach (var score in result)
        {
            Console.WriteLine(score);
        }
    }

    // Funkcija za kreiranje niza za igru
    static int[] CreateGameArray(int[] originalArray, int leftIndex, int rightIndex)
    {
        List<int> gameArray = new List<int>();

        // Dodavanje elemenata pre smicalice
        for (int i = 0; i < leftIndex - 1; i++)
        {
            gameArray.Add(originalArray[i]);
        }

        // Dodavanje elemenata posle smicalice
        for (int i = rightIndex; i < originalArray.Length; i++)
        {
            gameArray.Add(originalArray[i]);
        }

        return gameArray.ToArray();
    }

    // Funkcija za izracunavanje minimalnog skora
    static int CalculateMinScore(int[] gameArray)
    {
        int n = gameArray.Length;
        int[] dp = new int[n + 2];

        // Iterativni pristup za izracunavanje minimalnog skora
        for (int i = n; i >= 1; i--)
        {
            dp[i] = Math.Min(dp[i + 1] + gameArray[i - 1], dp[i + 2] + (i < n ? gameArray[i] : 0));
        }

        return dp[1];
    }
}