#include <stdio.h>
#include <stdlib.h>

// Funkcija koja racuna minimalan skor za igru za segment [L, R]
int minScore(int* A, int L, int R) {
    int minVal = A[L];
    for (int i = L + 1; i <= R; i++) {
        if (A[i] < minVal) {
            minVal = A[i];
        }
    }
    return minVal;
}

int main() {
    // Ucitavanje broja elemenata niza
    int N;
    scanf("%d", &N);

    // Ucitavanje elemenata niza A
    int* A = (int*)malloc(N * sizeof(int));
    for (int i = 0; i < N; i++) {
        scanf("%d", &A[i]);
    }

    // Ucitavanje broja smicalica
    int Q;
    scanf("%d", &Q);

    // Iteriranje kroz smicalice
    for (int i = 0; i < Q; i++) {
        int L, R;
        scanf("%d %d", &L, &R);

        // Racunanje minimalnog skora za trenutnu smicalicu
        int result = minScore(A, L - 1, R - 1);

        // Ispis rezultata
        printf("%d\n", result);
    }

    // Oslobadanje memorije
    free(A);

    return 0;
}