def min_score(N, A, Q, queries):
    # Inicijalizacija niza za igru
    game_array = list(A)
    prefix_sum = [0] * (N + 1)

    # Izracunajte prefiksne sume
    for i in range(1, N + 1):
        prefix_sum[i] = prefix_sum[i - 1] + A[i - 1]

    # Funkcija za pronalaženje minimalnog skora
    def find_min_score(start, end):
        return prefix_sum[end] - prefix_sum[start - 1]

    # Simulacija smicalica
    for query in queries:
        L, R = query
        score = 0

        # Ako smo obrisali elemente, dodaj ih ponovo
        if L > 1:
            score += find_min_score(1, L - 1)
        if R < N:
            score += find_min_score(R + 1, N)

        # Dodaj skor za svaki skok na poziciji i
        for i in range(L, R + 1):
            score += min(find_min_score(i, i), find_min_score(i + 1, i + 1))

        print(score)

# Citanje ulaza
N = int(input())
A = list(map(int, input().split()))
Q = int(input())
queries = [list(map(int, input().split())) for _ in range(Q)]

# Poziv funkcije za rešavanje problema
min_score(N, A, Q, queries)