import java.util.*;

public class Skolice {
    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        // Ucitavanje ulaznih podataka
        int N = scanner.nextInt();
        int[] A = new int[N];
        for (int i = 0; i < N; i++) {
            A[i] = scanner.nextInt();
        }

        int Q = scanner.nextInt();
        int[][] queries = new int[Q][2];
        for (int i = 0; i < Q; i++) {
            queries[i][0] = scanner.nextInt();
            queries[i][1] = scanner.nextInt();
        }

        // Rešavanje svakog upita
        for (int i = 0; i < Q; i++) {
            int Li = queries[i][0];
            int Ri = queries[i][1];

            // Pravljenje niza za igru nakon smicalice i
            int[] gameArray = createGameArray(A, Li, Ri);

            // Racunanje minimalnog skora
            int minScore = calculateMinScore(gameArray);

            // Ispisivanje rezultata
            System.out.println(minScore);
        }
    }

    // Pomocna funkcija za pravljenje niza za igru nakon smicalice i
    private static int[] createGameArray(int[] A, int Li, int Ri) {
        int[] gameArray = new int[A.length - (Ri - Li + 1)];
        int index = 0;

        for (int i = 0; i < A.length; i++) {
            if (i < Li - 1 || i >= Ri) {
                gameArray[index++] = A[i];
            }
        }

        return gameArray;
    }

    // Pomocna funkcija za racunanje minimalnog skora
    private static int calculateMinScore(int[] gameArray) {
        int[] dp = new int[gameArray.length + 2];

        for (int i = gameArray.length; i >= 1; i--) {
            dp[i] = gameArray[i - 1] + Math.min(dp[i + 1], dp[i + 2]);
        }

        return Math.min(dp[1], dp[2]);
    }
}