import java.util.*;

class Main {
    private static int[] arr, segTree, prefixSum, suffixSum;
    private static long[] dp;

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        int N = scanner.nextInt();
        arr = new int[N + 1];
        for (int i = 1; i <= N; i++) {
            arr[i] = scanner.nextInt();
        }

        buildSegmentTree();
        prefixSum = new int[N + 2];
        suffixSum = new int[N + 2];
        for (int i = 1; i <= N; i++) {
            prefixSum[i] = prefixSum[i - 1] + arr[i];
        }
        for (int i = N; i >= 1; i--) {
            suffixSum[i] = suffixSum[i + 1] + arr[i];
        }

        int Q = scanner.nextInt();
        dp = new long[Q + 2];
        for (int i = 1; i <= Q; i++) {
            int L = scanner.nextInt();
            int R = scanner.nextInt();
            dp[i] = Math.min(dp[i - 1], prefixSum[L - 1] + suffixSum[R + 1] - arr[L] - arr[R]);
        }

        for (int i = 1; i <= Q; i++) {
            System.out.println(dp[i]);
        }
    }

    private static void buildSegmentTree() {
        int segTreeSize = (int) (2 * Math.ceil(Math.log(arr.length) / Math.log(2)));
        segTree = new int[segTreeSize];
        Arrays.fill(segTree, Integer.MAX_VALUE);
        buildSegmentTreeHelper(1, 1, arr.length - 1);
    }

    private static void buildSegmentTreeHelper(int segTreeIndex, int arrStartIndex, int arrEndIndex) {
        if (arrStartIndex == arrEndIndex) {
            segTree[segTreeIndex] = arr[arrStartIndex];
            return;
        }
        int mid = (arrStartIndex + arrEndIndex) / 2;
        buildSegmentTreeHelper(2 * segTreeIndex, arrStartIndex, mid);
        buildSegmentTreeHelper(2 * segTreeIndex + 1, mid + 1, arrEndIndex);
        segTree[segTreeIndex] = Math.min(segTree[2 * segTreeIndex], segTree[2 * segTreeIndex + 1]);
    }
}