def min_score_after_removal(N, A, Q, queries):
    prefix_sum = [0] * (N + 1)
    for i in range(1, N + 1):
        prefix_sum[i] = prefix_sum[i - 1] + A[i - 1]

    result = []

    for i in range(Q):
        L, R = queries[i]

        # Izracunaj ukupan skor pre i posle brisanja elemenata
        total_score_before = prefix_sum[R] - prefix_sum[L - 1]
        total_score_after = prefix_sum[L - 1] + prefix_sum[N] - prefix_sum[R]

        # Pronadi minimalni skor
        min_score = min(total_score_before, total_score_after)

        result.append(min_score)

    return result

# Ucitaj ulazne podatke
N = int(input())
A = list(map(int, input().split()))
Q = int(input())

queries = []
for _ in range(Q):
    L, R = map(int, input().split())
    queries.append((L, R))

# Pozovi funkciju i ispiši rezultate
result = min_score_after_removal(N, A, Q, queries)
for score in result:
    print(score)