import java.util.Arrays;
import java.util.Scanner;

public class ObaranjeRuku {

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        // Citanje ulaznih podataka
        int N = scanner.nextInt();
        int[] P = new int[N];
        for (int i = 0; i < N; i++) {
            P[i] = scanner.nextInt();
        }

        int Q = scanner.nextInt();

        // Citanje i obrada svake opcije
        for (int q = 0; q < Q; q++) {
            int Mi = scanner.nextInt();
            int Ji = scanner.nextInt();

            // Obrada trenutne opcije
            int[] powers = Arrays.copyOf(P, N);
            int rounds = calculateRounds(N, powers, Mi, Ji);
            
            // Ispis rezultata za trenutnu opciju
            System.out.println(rounds);
        }

        scanner.close();
    }

    // Funkcija koja racuna najviši krug do kojeg može stici mišljenik Mi
    private static int calculateRounds(int N, int[] powers, int Mi, int Ji) {
        int rounds = 0;

        // Inicijalizacija niza indeksa sortiranih po snazi
        Integer[] sortedIndices = new Integer[N];
        for (int i = 0; i < N; i++) {
            sortedIndices[i] = i;
        }
        Arrays.sort(sortedIndices, (a, b) -> Integer.compare(powers[b], powers[a]));

        // Zamenjujemo parove dok god ima zamena i dok ne potrošimo sva dozvoljena zamene
        while (true) {
            boolean swapped = false;
            for (int i = 0; i < N - 1; i += 2) {
                int index1 = sortedIndices[i];
                int index2 = sortedIndices[i + 1];

                // Provera da li je mišljenik u paru i zamenjujemo ih ako jeste
                if ((index1 + 1 == Mi || index2 + 1 == Mi) && Ji > 0) {
                    int temp = powers[index1];
                    powers[index1] = powers[index2];
                    powers[index2] = temp;
                    swapped = true;
                    Ji--;
                }
            }

            // Ako nismo izvršili nijednu zamenu, prekidamo petlju
            if (!swapped) {
                break;
            }

            // Sortiramo ponovo indekse prema snazi nakon zamene
            Arrays.sort(sortedIndices, (a, b) -> Integer.compare(powers[b], powers[a]));

            rounds++;
        }

        return rounds;
    }
}