from typing import List, Tuple

def minimalni_skor(N: int, A: List[int], Q: int, smicalice: List[Tuple[int, int]]) -> List[int]:
    def ubaci_s_niz(s: List[int], l: int, r: int) -> List[int]:
        return s[:l] + s[r:]

    def dynamicka_proga(s: List[int]) -> int:
        dp = [0] * (len(s) + 3)
        for i in range(len(s), 0, -1):
            dp[i] = s[i - 1] + min(dp[i + 1], dp[i + 2])
        return dp[1]

    skorovi = []
    for l, r in smicalice:
        skorovi.append(dynamicka_proga(ubaci_s_niz(A, l, r)))

    return skorovi

# Ulazni podaci
N = int(input())
A = list(map(int, input().split()))
Q = int(input())
smicalice = [tuple(map(int, input().split())) for _ in range(Q)]

# Poziv funkcije i ispis rezultata
rezultati = minimalni_skor(N, A, Q, smicalice)
for rezultat in rezultati:
    print(rezultat, end=" ")