using System;
using System.Collections.Generic;

class Takmicenje
{
    static int NajmanjiSkor(int[] niz)
    {
        int n = niz.Length;

        if (n == 0)
            return 0;

        if (n == 1)
            return niz[0];

        int[] skorovi = new int[n];
        skorovi[0] = niz[0];
        skorovi[1] = Math.Min(niz[0] + niz[1], niz[1]);

        for (int i = 2; i < n; i++)
        {
            skorovi[i] = Math.Min(skorovi[i - 1] + niz[i], skorovi[i - 2] + niz[i]);
        }

        return Math.Min(skorovi[n - 1], skorovi[n - 2]);
    }

    static int[] IzbrisiInterval(int[] niz, int pocetnaPozicija, int krajnjaPozicija)
    {
        List<int> rezultatnaLista = new List<int>();

        for (int i = 0; i < niz.Length; i++)
        {
            if (i < pocetnaPozicija - 1 || i > krajnjaPozicija - 1)
            {
                rezultatnaLista.Add(niz[i]);
            }
        }

        int[] rezultatniNiz = rezultatnaLista.ToArray();

        return rezultatniNiz;
    }

    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        string[] s = Console.ReadLine().Split();

        int[] igra = new int[n];
        for (int i = 0; i < n; i++)
        {
            igra[i] = int.Parse(s[i]);
        }

        int q = int.Parse(Console.ReadLine());

        
        List<int> rezultati = new List<int>();

        for (int k = 0; k < q; k++)
        {
            string[] lr = Console.ReadLine().Split();
            int l = int.Parse(lr[0]);
            int r = int.Parse(lr[1]);

            int[] niz2 = IzbrisiInterval(igra, l, r);
            rezultati.Add(NajmanjiSkor(niz2));
        }

        
        foreach (int rezultat in rezultati)
        {
            Console.WriteLine(rezultat);
        }
    }
}