#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

// ???????? ?? ???????? ?????????? ????? ?? ???? ???
int calculateMinScore(const vector<int>& arr) {
    int n = arr.size();
    vector<int> dp(n + 2, 0);

    for (int i = n; i > 0; --i) {
        dp[i] = arr[i - 1] + min(dp[i + 1], dp[i + 2]);
    }

    return min(dp[1], dp[2]);
}

int main() {
    int N;
    cin >> N;

    vector<int> A(N);
    for (int i = 0; i < N; ++i) {
        cin >> A[i];
    }

    int Q;
    cin >> Q;

    vector<vector<int>> pranks(Q, vector<int>(2));
    for (int i = 0; i < Q; ++i) {
        cin >> pranks[i][0] >> pranks[i][1];
    }

    // ?????? ????????? ?? ?????? ?????
    for (const auto& prank : pranks) {
        int L = prank[0], R = prank[1];
        if (L > R) {
            swap(L, R);
        }

        vector<int> arr(A.begin() + R, A.end());
        arr.insert(arr.end(), A.begin(), A.begin() + L - 1);

        // ????? ?????????? ????? ?? ???????? ?????????
        cout << calculateMinScore(arr) << endl;
    }

    return 0;
}