#include <iostream>
#include <vector>
#include <algorithm>

double calculateAverageScore(const std::vector<int>& scores) {
    int numTest = scores.size();
    if (numTest < 2) {
        throw std::invalid_argument("Need at least two scores to calculate average");
    }

    // Sort the scores and find the lowest
    std::vector<int> sortedScores = scores;
    std::sort(sortedScores.begin(), sortedScores.end());
    int lowestScore = sortedScores[0];

    // Calculate the sum of all scores except the lowest
    double sum = 0;
    for (int i = 1; i < numTest; i++) {
        sum += scores[i];
    }

    // Calculate the average of all scores except the lowest
    double average = sum / (numTest - 1);

    return average;
}

int main() {
    std::vector<int> scores = {1, 2, 3, 4, 5};
    try {
        double average = calculateAverageScore(scores);
        std::cout << "The average score is: " << average << std::endl;
    } catch (const std::invalid_argument& e) {
        std::cerr << "Error: " << e.what() << std::endl;
    }

    return 0;
}