#include <iostream>
#include <algorithm>

using namespace std;

const int MAX_SIZE = 100000;

int minSumToReachEnd(const int niz[], int n) {
    int minSum[MAX_SIZE];
    minSum[0] = niz[0];

    for (int i = 1; i < n; i++) {
        minSum[i] = min(minSum[i - 1], (i - 2 >= 0 ? minSum[i - 2] : 0)) + niz[i];
    }

    return minSum[n - 1];
}

void BezNula(int niz[], int &size) {
    int BezNultiI = 0;

    for (int i = 0; i < size; i++) {
        if (niz[i] != 0) {
            niz[BezNultiI++] = niz[i];
        }
    }

    for (int i = BezNultiI; i < size; i++) {
        niz[i] = 0;
    }

    if (BezNultiI == 0) {
        niz[0] = 0;
        BezNultiI = 1;
    }

    size = BezNultiI;
}

void removeItemsBetween(int niz[], int size, int L, int R) {
    if (L < 1 || R > size || L > R) {
        for (int i = 0; i <= R; i++) {
            niz[i] = 0;
        }
        return;
    }

    for (int i = L; i <= R; i++) {
        niz[i] = 0;
    }

    BezNula(niz, size);
}

int main() {
    int N;
    int minSum;
    cin >> N;
    cout << endl;

    int niz[MAX_SIZE];

    for (int i = 0; i < N; i++) {
        cin >> niz[i + 1];
    }
    niz[N + 2] = 0;
    niz[0] = 0;
    int Q;
    cin >> Q;

    for (int q = 0; q < Q; q++) {
        int L, R;
        cin >> L >> R;
        L;
        R;
        int kopija[MAX_SIZE + 1];
        copy(niz, niz + N + 1, kopija);

        removeItemsBetween(kopija, N + 1, L, R);

        minSum = minSumToReachEnd(kopija, N + 2);

        cout << minSum << endl;
    }

    return 0;
}