#include <iostream>
#include <vector>
#include <algorithm>

struct podigra {
	unsigned x1;
	unsigned x2;
};

std::vector<int> ObrisiPolja(std::vector<int> polja, const int b1, const int b2) {
	polja.erase(polja.begin() + b1 - 1, polja.begin() + b2);
	return polja;
}

int MinPoeni(const std::vector<int>& polja, int n) {
	if (n > 1) return std::min(MinPoeni(polja, n - 1), MinPoeni(polja, n - 2)) + polja[n];
	else return polja[n];
}

void Igra(std::vector<int> polja) {
	int poeni;

	polja.push_back(0);
	unsigned n = polja.size();

	poeni = MinPoeni(polja, n - 1);
	std::cout << poeni << std::endl;
}

int main() {

	unsigned n, m;
	std::cin >> n;

	std::vector<int> polja(n);
	for (auto& x : polja) std::cin >> x;

	std::cin >> m;

	if (m > 0) {
		std::vector<podigra> igre(m);

		for (auto& x : igre) {
			std::cin >> x.x1 >> x.x2;
			if (x.x1 > x.x2) return 1;
		}

		for (auto& x : igre) {
			std::vector<int> novaPolja = ObrisiPolja(polja, x.x1, x.x2);
			Igra(novaPolja);
		}
	}
	else Igra(polja);

	return 0;
}