#include <iostream>
#include <cstdint>
#include <array>

constexpr int N_MAX = 200'000;
std::array<int, N_MAX> niz;

int n;
int l, r;

class Min
{
public:
    static void SetMin(int64_t min)
    {
        if (min < s_Min)
        {
            s_Min = min;
        }
    }

    static void SetToMax()
    {
        s_Min = INT64_MAX;
    }

    static int64_t GetMin()
    {
        return s_Min;
    }
private:
    static int64_t s_Min;
};

int64_t Min::s_Min = INT64_MAX;

void pretraga(int64_t suma, int trenutno_mesto)
{
    if (suma >= Min::GetMin())
    {
        return;
    }

    if (trenutno_mesto >= n)
    {
        Min::SetMin(suma);
        return;
    }

    if (trenutno_mesto >= l && trenutno_mesto <= r)
    {
        if (r == n - 1)
        {
            Min::SetMin(suma);
            return;
        }
        
        trenutno_mesto = r + 1 + (trenutno_mesto - l);
    }

    if (trenutno_mesto == -1)
    {
        pretraga(suma, trenutno_mesto + 1);
        pretraga(suma, trenutno_mesto + 2);
        return;
    }

    pretraga(suma + niz[trenutno_mesto], trenutno_mesto + 1);
    pretraga(suma + niz[trenutno_mesto], trenutno_mesto + 2);
}

int main(int argc, char const *argv[])
{
    std::ios_base::sync_with_stdio(false);
    std::cin >> n;

    bool sve_jedan = true;
    for (int i = 0; i < n; i++)
    {
        std::cin >> niz[i];

        if (niz[i] != 1)
        {
            sve_jedan = false;
        }
    }

    int q;
    std::cin >> q;
    
    std::string odgovor;
    
    while (q--)
    {
        std::cin >> l >> r;
        l--;
        r--;

        if (sve_jedan)
        {
            odgovor += std::to_string((n - (r - l + 1)) / 2) + '\n';
        }
        else
        {
            Min::SetToMax();
            pretraga(0ll, -1);
            odgovor += std::to_string(Min::GetMin()) + '\n';
        }
    }

    std::cout << odgovor;

    return 0;
}